/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import snownee.kiwi.Kiwi;

public class ModContext {
    public static final Map<String, ModContext> ALL_CONTEXTS = Maps.newHashMap();
    public ModContainer modContainer;
    public Supplier<?> extension;

    public static ModContext get(String modid) {
        if (ALL_CONTEXTS.containsKey(modid)) {
            return ALL_CONTEXTS.get(modid);
        }
        ModContext context = new ModContext(modid);
        ALL_CONTEXTS.put(modid, context);
        return context;
    }

    private ModContext(String modid) {
        Preconditions.checkNotNull((Object)modid, (Object)"Cannot get name of kiwi module.");
        try {
            this.modContainer = (ModContainer)ModList.get().getModContainerById(modid).get();
            this.extension = (Supplier)Kiwi.FIELD_EXTENSION.get(this.modContainer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchElementException e) {
            Kiwi.logger.catching((Throwable)e);
        }
    }

    public void setActiveContainer() {
        ModLoadingContext.get().setActiveContainer(this.modContainer, this.extension.get());
    }
}

